
markup.push({

// MARK: time shift

TimeShiftBlock:
{
	"+": "BlockTemplate",
	gxPopoverInfo: "TimeShiftPopover",
	gxTitle: "Time Shift",
	geNodeClass: "GETimeShiftNode",
	gxLibraryDescription: "Pause and rewind live audio",
	gxLibraryIcon: "library.time.shift",
	gxChildViews:
	[
		// current delay
		{
			"+": "LabelView.blockReadout.size15",
			gxAnimateOnKey: "running",
			gxFrameRect: "12,47,96,22",
			gxValueKey: "node.physicalDelayDescription"
		},
		// pause/resume button
		{
			"+": "BlockButton.leftSegment",
            gxButtonType: "toggle",
			axTitleKeyPath: "node.pauseResumeBtnTitle",
			gxForePainter: "ImagePainter.timeshift.blockpause",
			gxDisableOnKey: "node.bypassed",
			gxFrameRect: "14,85,25,18",
			gxToolTip: "Pause",
			gxOnToolTip: "Resume",
			gxValueKey: "node.paused"
		},
		// jump back button
		{
			"+": "BlockButton.middleSegment",
			gxAnimateOnKey: "running",
			//gxDisplayValueKey: "node.jumpBack2BtnDescription",
			gxForePainter: "ImagePainter.foreColorTheme1.timeshift.back",
			gxDisableOnKey: "node.jumpBackDisabled",
			gxFrameRect: "38,85,23,18",
			gxToolTipKeyPath: "node.jumpBack2BtnDescription",
			axTitleKeyPath: "node.jumpBack2BtnDescription",
			gxValueKey: "node.jumpBack2Btn"
		},
		// jump forward button
		{
			"+": "BlockButton.middleSegment",
			gxAnimateOnKey: "running",
			//gxDisplayValueKey: "node.jumpForward2BtnDescription",
			gxForePainter: "ImagePainter.timeshift.fwd",
			gxDisableOnKey: "node.jumpForwardDisabled",
			gxFrameRect: "60,85,23,18",
			gxToolTipKeyPath: "node.jumpForward2BtnDescription",
			axTitleKeyPath: "node.jumpForward2BtnDescription",
			gxValueKey: "node.jumpForward2Btn"
		},
		// jump to live button
		{
			"+": "BlockButton.rightSegment",
			gxAnimateOnKey: "running",
			axTitle: "Jump to Live",
			gxForePainter: "ImagePainter.timeshift.live",
			gxDisableOnKey: "node.jumpForwardDisabled",
			gxFrameRect: "82,85,24,18",
			gxToolTip: "Jump To Live",
			gxValueKey: "node.jumpToLiveBtn"
		}
	 ]
},

TimeShiftButton: {
	"+": "ButtonView",
	gxIntrinsicHeight: 26
},

	
// MARK: time shift popover

TimeShiftPopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Time Shift",
	gxLayout: [
		"H:|-12-[self]-12-|",
		"V:|-12-[self]-12-|"
	],
	gxCanDrawSubviewsIntoLayer: true,
	gxWantsLayer: true,
	gxChildViews:
	{
		title: "PopoverTitle",
		switch: "PopoverOnOffSwitch",
		group:
		{
			"+": "GroupView.noBottomStroke",
			gxLayout: [
				"V:|-41-[self]-10-|",
				"H:|-0-[self]-0-|",
				"H:|-12-[slider]-12-|",
				"V:|-12-[curdelay]-(-1)-[slider]-7-[back_label]-5-[pause]-4-|",
				"H:|-16-[back_label]-(>=0)-[forward_label]-83-|&alignBaseline",
				"H:|-12-[back3(==back)]-(-1)-[back2(==back)]-(-1)-[back(36)]-8-[pause]&alignCenterY",
				"H:[pause(50)]-8-[forward(36)]-(-1)-[forward2(==forward)]-(-1)-[forward3(==forward)]-20-[live(==pause)]-12-|&alignCenterY"
			],
			gxChildViews:
			{
				curdelay: {
					"+": "LabelView.right.colorThemeLive2.size125",
					gxLayout: [ "H:[self(100)]-12-|" ],
					gxAnimateOnKey: "running",
					gxValueKey: "node.physicalDelayDescription"
				},
				slider: {
					"+": "SliderView",
                    axValueKeyPath: "node.physicalDelayDescription",
					axTitle: "Time Shift",
					axHelp: "Controls how far behind real time playback is.",
					gxDisableOnKey: "node.bufferIsEmpty",
					gxAnimateOnKey: "running",
					gxKeystrokeStepSizeKeyPath: "node.stepSize",
					gxValueKey: "node.oneMinusDelayPercent"
				},
				back_label: {
					"+": "LabelView.useMarkup.left.size12",
					gxDefaultValue: "<icon.foreColor2.timeshift.arrow.left/> Jump Back"
				},
				forward_label: {
					"+": "LabelView.useMarkup.right.size12",
					gxDefaultValue: "Jump Forward <icon.foreColor2.timeshift.arrow.right/>"
				},
				back3: {
					"+": "TimeShiftButton.leftSegment",
					gxAnimateOnKey: "running",
					axTitleKeyPath: "node.jumpBack3BtnDescription",
					gxDisableOnKey: "node.jumpBackDisabled",
					gxDisplayValueKey: "node.jumpBack3BtnTitle",
					gxValueKey: "node.jumpBack3Btn"
				},
				back2: {
					"+": "TimeShiftButton.middleSegment",
					gxAnimateOnKey: "running",
					axTitleKeyPath: "node.jumpBack2BtnDescription",
					gxDisableOnKey: "node.jumpBackDisabled",
					gxDisplayValueKey: "node.jumpBack2BtnTitle",
					gxValueKey: "node.jumpBack2Btn"
				},
				back: {
					"+": "TimeShiftButton.rightSegment",
					gxAnimateOnKey: "running",
					axTitleKeyPath: "node.jumpBackBtnDescription",
					gxDisableOnKey: "node.jumpBackDisabled",
					gxDisplayValueKey: "node.jumpBackBtnTitle",
					gxValueKey: "node.jumpBackBtn"
				},
				pause: {
					"+": "TimeShiftButton",
                    gxButtonType: "toggle",
					axTitleKeyPath: "node.pauseResumeBtnTitle",
					gxForePainter: "ImagePainter.foreColor1.timeshift.pause",
					gxValueKey: "node.paused"
				},
				forward: {
					"+": "TimeShiftButton.leftSegment",
					gxAnimateOnKey: "running",
					axTitleKeyPath: "node.jumpForwardBtnDescription",
					gxDisableOnKey: "node.jumpForwardDisabled",
					gxDisplayValueKey: "node.jumpForwardBtnTitle",
					gxValueKey: "node.jumpForwardBtn"
				},
				forward2: {
					"+": "TimeShiftButton.middleSegment",
					gxAnimateOnKey: "running",
					axTitleKeyPath: "node.jumpForward2BtnDescription",
					gxDisableOnKey: "node.jumpForwardDisabled",
					gxDisplayValueKey: "node.jumpForward2BtnTitle",
					gxValueKey: "node.jumpForward2Btn"
				},
				forward3: {
					"+": "TimeShiftButton.rightSegment",
					gxAnimateOnKey: "running",
					axTitleKeyPath: "node.jumpForward3BtnDescription",
					gxDisableOnKey: "node.jumpForwardDisabled",
					gxDisplayValueKey: "node.jumpForward3BtnTitle",
					gxValueKey: "node.jumpForward3Btn"
				},
				live: {
					"+": "TimeShiftButton",
					gxAnimateOnKey: "running",
					axTitle: "Jump to Live",
					gxDisableOnKey: "node.jumpForwardDisabled",
					gxTitle: "Live",
					gxValueKey: "node.jumpToLiveBtn"
				}
			}
		}
	}
},


})
